### Edit Menu

The Edit menu contains menu items that affect the contents within the current file.  The following table describes the items available within this menu.

| Menu Item | Shortcut<br>(Mac) | Shortcut<br>(Other) | Description |
| - | - | - | - |
| Undo | Cmd-Z | Ctrl-Z | Undoes the last change made to the file content.  Each file can have an unlimited number of items that can be undone.  Saving a file clears the undo stack for that file. |
| Redo | Cmd-R | Ctrl-R | Re-applies the last undone change made to the file content.  Saving a file clears the redo stack for that file. |
| Cut | Cmd-X | Ctrl-X | Deletes the selected text, copying the deleted content to the clipboard.  If no text is currently selected, the current line is deleted and sent to the clipboard. |
| Copy | Cmd-C | Ctrl-C | Copies the selected text to the clipboard.  If no text is currently selected, the current line is copied to the clipboard. |
| Paste | Cmd-V | Ctrl-V | Pastes the content in the clipboard, inserting the text before the insertion cursor.  The content is copied “as is”. |
| Paste and Format | Shift-Cmd-V | Shift-Ctrl-V | Pastes the content in the clipboard, inserting the text before the insertion cursor.  The content is indented to fit into the current insertion point. |
| Select / All | | | Selects all of the text in the current editor. |
| Select / Current Line | | | Selects the entire line that the insertion cursor is on. |
| Select / Current Word | | | Selects the word that the insertion cursor is on or closest to. |
| Select / Current Sentence | | | Selects the sentence that the insertion cursor is on or closest to. |
| Select / Current Paragraph | | | Selects the paragraph that the insertion cursor is on or closest to. |
| Select / Current Bounded Text | | | Selects all text between the closest curly bracket, square bracket, parenthesis, angled bracket, double-quoted string, single-quoted string or backtick pair. |
| Select / Add Next Line | | | Adds the line immediately following the current selection to the selection. |
| Select / Add Previous Line | | | Adds the line immediately preceding the current selection to the selection. |
| Select Mode | Cmd-A | Ctrl-A | Enters [selection mode](#select_mode) which provides fine-grained selection control via the keyboard. |
| Vim Mode | | | When selected, changes the editing environment to use Vim-style interaction.  When deselected, changes the editing environment back to “normal” editing mode. |
| Toggle Comment | Ctrl-/ | Ctrl-/ | Detects the comment state of the current selection.  If the selected text is not commented out, places a line comment in front of any selected text in the current file.  If the selected text is commented out, the comments are removed from the selected lines.  If a selection does not exist, the current line (or lines, if multicursors are enabled) is commented/uncommented in a similar fashion. |
| Indentation / Indent | Ctrl-] | Ctrl-] | Indents the selected text by one level of indentation. |
| Indentation / Unindent | Ctrl-[ | Ctrl-[ | Unindents the selected text by one level of indentation. |
| Indentation / Format Text | Ctrl-&#124; | Ctrl-&#124; | Modifies either the selected text or the entire file content (depending on whether text is currently selected or not) to match the indentation in the current context. |
| Indentation / Indent Off | | | Turns indentation mode off for the current editor.  Hitting the ENTER key in the editing window will place the cursor in the first column of the next row. |
| Indentation / Auto-Indent | | | Turns auto-indentation mode on for the current editor.  Hitting the ENTER key in the editing window will place the cursor in the same column as the previous line’s starting character. |
| Indentation / Smart Indent | | | Turns smart indentation mode on for the current editor.  Hitting the ENTER key in the editing window will perform the proper indentation based on the current language and context.  If a character sequence is entered that completes an indentation, the character sequence will be adjusted to the proper indentation level. |
| Cursor / Move to First Line | Alt-Cmd-0 | Ctrl-Alt-0 | Moves the cursor to the start of the first line of the file and adjusts the view so the cursor is visible. |
| Cursor / Move to Last Line | Alt-Cmd-9 | Ctrl-Alt-9 | Moves the cursor to the start of the last line of the file and adjusts the view so the cursor is visible. |
| Cursor / Move to Next Page | Ctrl-F | Ctrl-F | Moves the cursor down by a single page and adjusts the view so the cursor is visible. |
| Cursor / Move to Previous Page | Ctrl-B | Ctrl-B | Moves the cursor up by a single page and adjusts the view so the cursor is visible. |
| Cursor / Move to Screen Top | Alt-Cmd-H | Ctrl-Alt-H | Moves the cursor to the start of the line at the top of the current screen. |
| Cursor / Move to Screen Middle | Alt-Cmd-M | Ctrl-Alt-M | Moves the cursor to the start of the line in the middle of the current screen. |
| Cursor / Move to Screen Bottom | Alt-Cmd-L | Ctrl-Alt-L | Moves the cursor to the start of the line at the bottom of the current screen. |
| Cursor / Move to Line Start | Alt-Cmd-^ | Ctrl-Alt-^ | Moves the cursor to the start of the current line. |
| Cursor / Move to Line End | Alt-Cmd-$ | Ctrl-Alt-$ | Moves the cursor to the end of the current line. |
| Cursor / Move to Next Word | Alt-Cmd-W | Ctrl-Alt-W | Moves the cursor to the beginning of the next word. |
| Cursor / Move to Previous Word | Alt-Cmd-P | Ctrl-Alt-P | Moves the cursor to the beginning of the previous word. |
| Cursor / Move Cursors Up | Alt-Cmd-Up | Ctrl-Alt-Up | In multicursor mode, moves all of the cursors up by one line. |
| Cursor / Move Cursors Down | Alt-Cmd-Down | Ctrl-Alt-Down | In multicursor mode, moves all of the cursors down by one line. |
| Cursor / Move Cursors Left | Alt-Cmd-Left | Ctrl-Alt-Left | In multicursor mode, moves all of the cursors to the left by one character. |
| Cursor / Move Cursors Right | Alt-Cmd-Right | Ctrl-Alt-Right | In multicursor mode, moves all of the cursors to the right by one character. |
| Cursor / Align Cursors Only | Shift-Ctrl-Alt-A | Shift-Ctrl-Alt-A | When multicursors are set in the current file, this command will adjust the cursors in each line so that they are aligned to the cursor which is closest to the beginning of the line |
| Cursor / Align Cursors and Text | Ctrl-Alt-A | Ctrl-Alt-A | When multicursors are set in the current file, this command will adjust each line such that all cursors (and all text from the cursor to the end of the line) will be aligned to the same column.  The cursors will be aligned to the highest column in the multicursor set. |
| Insert / Line Above Current | Shift-Alt-O | Shift-Alt-O | Inserts a blank line above the current line and places the cursor at the beginning of the blank line for editing. |
| Insert / Line Below Current | Alt-O | Alt-O | Inserts a blank line below the current line and places the cursor at the beginning of the blank line for editing. |
| Insert / File Contents | | | Prompts the user to select a file for insertion. If a file is selected, the entire contents of the file are inserted the line below the current line. |
| Insert / Command Result | | | Prompts the user to input a shell command. If a legal shell command is entered, the result of the command is inserted below the current line. |
| Insert / From Clipboard | Alt-C | Alt-C | Displays the command launcher in clipboard mode to allow the user to view and select one of the clipboard history elements to insert into the current editor. |
| Insert / Snippet | Alt-S | Alt-S | Displays the command launcher in snippet mode to allow the user to view and select one of the language-specific snippets to insert into the current editor. |
| Insert / Enumeration | Alt-1 | Alt-1 | When one or more multicursors are set, allows the user to insert ascending numerical values at each cursor insertion position. |
| Transform / Toggle Case | | | Toggles the case of the character at the current insertion cursor or of all selected characters. |
| Transform / Lower Case | Ctrl-Alt-L | Alt-L | Sets the case of the character at the current cursor or all selected characters to lower case. |
| Transform / Upper Case | Ctrl-Alt-U | Alt-U | Sets the case of the character at the current cursor or all selected characters to upper case. |
| Transform / Title Case | Ctrl-Alt-T | Alt-T | Sets the case of the character at the current cursor or all selected characters such that the first character of each word is capitalized while all other characters are placed into lower case. |
| Transform / Join Lines | Cmd-J | Ctrl-J | If multiple lines are selected, joins all lines containing a selection are joined with a single space character into one line.  If no lines are selected, the line below the current line is joined to the current line. |
| Transform / Bubble Up | Cmd-Up | Alt-Up | If multiple lines are selected, all selected lines are moved up by one line (the line above will be moved below the bubbled line(s)); otherwise, the current line is bubbled up one line. If the selected text was selected using Select Mode and the selection refers to a sentence, paragraph or XML/HTML node, bubble up will move the selected items up by one item unit. If the item is a sentence, and it is the first sentence of a paragraph, bubble up will cause the sentence to be placed at the end of the previous paragraph. |
| Transform / Bubble Down | Cmd-Down | Alt-Down | If multiple lines are selected, all selected lines are moved down by one line (the line below will be moved above the bubbled line(s)); otherwise, the current line is bubbled down by one line. If the selected text was selected using Select Mode and the selection refers to a sentence, paragraph or XML/HTML node, bubble down will move the selected items down by one item unit. If the item is a sentence, and it is the last sentence of the paragraph, bubble down will cause the sentence to be placed at the beginning of the next paragraph. |
| Transform / Replace Line With Script | | | If the current line contains an executable shell command, the command is executed and the resulting output replaces the current line. |
| Format / Bold | Cmd-B | Shift-Alt-B | Inserts the bold syntax associated with the current language. If text is selected, bolds the selected text. If no text is selected, bolds the current word (if the cursor is not on a word, it will insert the bold syntax and place the insertion cursor between the syntax characters). If multicursors are set, bolds the word that each multicursor is in. |
| Format / Italics | Cmd-I | Shift-Alt-I | Inserts the italicize syntax associated with the current language. If text is selected, italicizes the selected text. If no text is selected, italicizes the current word (if the cursor is not on a word, it will insert the italics syntax and place the insertion cursor between the syntax characters). If multicursors are set, italicizes the word that each multicursor is in. |
| Format / Underline | Cmd-U | Shift-Alt-U | Inserts the underline syntax associated with the current language. If text is selected, underlines the selected text. If no text is selected, underlines the current word (if the cursor is not on a word, it will insert the underline syntax and place the insertion cursor between the syntax characters). If multicursors are set, underlines the word that each multicursor is in. |
| Format / Strikethrough | | | Inserts the strikethrough syntax associated with the current language. If text is selected, overstrikes the selected text. If no text is selected, overstrikes the current word (if the cursor is not on a word, it will insert the strikethrough syntax and place the insertion cursor between the syntax characters). If multicursors are set, underlines the word that each multicursor is in. |
| Format / Highlight | | | Inserts the highlight syntax associated with the current language. If text is selected, highlights the selected text. If no text is selected, highlights the current word (if the cursor is not on a word, it will insert the highlight syntax and place the insertion cursor between the syntax characters). If multicursors are set, highlights the word that each multicursor is in. |
| Format / Superscript | | | Inserts the superscript syntax associated with the current language. If text is selected, superscripts the selected text. If no text is selected, superscripts the current word (if the cursor is not on a word, it will insert the superscript syntax and place the insertion cursor between the syntax characters). If multicursors are set, superscripts the word that each multicursor is in. |
| Format / Subscript | | | Inserts the subscript syntax associated with the current language. If text is selected, subscripts the selected text. If no text is selected, subscripts the current word (if the cursor is not on a word, it will insert the subscript syntax and place the insertion cursor between the syntax characters). If multicursors are set, subscripts the word that each multicursor is in. |
| Format / Code | | | Inserts the code (mono-spaced font) syntax associated with the current language. If text is selected, codifies the selected text. If no text is selected, codifies the current word (if the cursor is not on a word, it will insert the code syntax and place the insertion cursor between the syntax characters). If multicursors are set, codifies the word that each multicursor is in. |
| Format / Header 1 | | | Inserts the header 1 syntax associated with the current language. If text is selected, the header 1 syntax will be placed at the beginning of each line containing a selection. If no text is selected, the header 1 syntax will be placed at the beginning of the current line. If multicursors are set, header 1 syntax will be inserted at each line containing a multicursor. |
| Format / Header 2 | | | Inserts the header 2 syntax associated with the current language. If text is selected, the header 2 syntax will be placed at the beginning of each line containing a selection. If no text is selected, the header 2 syntax will be placed at the beginning of the current line. If multicursors are set, header 2 syntax will be inserted at each line containing a multicursor. |
| Format / Header 3 | | | Inserts the header 3 syntax associated with the current language. If text is selected, the header 3 syntax will be placed at the beginning of each line containing a selection. If no text is selected, the header 3 syntax will be placed at the beginning of the current line. If multicursors are set, header 3 syntax will be inserted at each line containing a multicursor. |
| Format / Header 4 | | | Inserts the header 4 syntax associated with the current language. If text is selected, the header 4 syntax will be placed at the beginning of each line containing a selection. If no text is selected, the header 4 syntax will be placed at the beginning of the current line. If multicursors are set, header 4 syntax will be inserted at each line containing a multicursor. |
| Format / Header 5 | | | Inserts the header 5 syntax associated with the current language. If text is selected, the header 5 syntax will be placed at the beginning of each line containing a selection. If no text is selected, the header 5 syntax will be placed at the beginning of the current line. If multicursors are set, header 5 syntax will be inserted at each line containing a multicursor. |
| Format / Header 6 | | | Inserts the header 6 syntax associated with the current language. If text is selected, the header 6 syntax will be placed at the beginning of each line containing a selection. If no text is selected, the header 6 syntax will be placed at the beginning of the current line. If multicursors are set, header 6 syntax will be inserted at each line containing a multicursor. |
| Format / Unordered | | | Inserts the unordered item syntax associated with the current language. If text is selected, the unordered syntax will be placed at the beginning of each line containing a selection. If no text is selected, the unordered syntax will be placed at the beginning of the current line. If multicursors are set, unordered syntax will be inserted at each line containing a multicursor. |
| Format / Ordered | | | Inserts the ordered item syntax associated with the current language. If text is selected, the ordered syntax will be placed at the beginning of each line containing a selection. If no text is selected, the ordered syntax will be placed at the beginning of the current line. If multicursors are set, ordered syntax will be inserted at each line containing a multicursor. |
| Format / Checkbox | | | Inserts the checkbox syntax associated with the current language. If text is selected, the checkbox syntax will be placed at the beginning of each line containing a selection. If no text is selected, the checkbox syntax will be placed at the beginning of the current line. If multicursors are set, checkbox syntax will be inserted at each line containing a multicursor. |
| Format / Remove Formatting | Cmd- - | Ctrl- - | Removes any text formatting that is insertable by the formatting menu. If text is selected, all formatting will be removed from the selection. If text is not selected, all formatting will be removed from the current line. If multicursors are set, all formatting will be removed from each line that contains a multicursor. |
| Snippets / Edit User | | | Adds the user's global snippet file into the editor. |
| Snippets / Edit Language | | | Adds the user’s snippet file into the editor for the current language. |
| Snippets / Reload | | | Reloads the contents of the snippets for the current language and user.  Useful if the snippet file contents are not usable within the editor. |
| Templates / Edit | | | Opens an existing named template for editing. |
| Templates / Delete | | | Deletes an existing named template. |
| Templates / Reload | | | Reloads the names of the existing templates. |
| Emmet / Expand Abbreviation | Ctrl-E | Ctrl-E | Expands the Emmet abbreviation syntax that is found to the left of the cursor (i.e., cursor must be placed on the right side of the abbreviation for proper expansion to occur). |
| Emmet / Wrap With Abbreviation | | | Allows the user to wrap selected text in the buffer with an Emmet abbreviation. When this option is selected, an entry field at the bottom of the window will allow you to add the Emmet wrapping syntax. When the RETURN key is entered, the abbreviation will be expanded and the selected text inserted into the expansion in the appropriate location. The expanded text will then replace the selected text in the current buffer. |
| Emmet / Balance Outward | | | Selects text in the buffer that contains the current tag based on the current insertion cursor. Calling this function again will expand the selection to include the parent tag. Only valid for XML-like syntaxes. |
| Emmet / Balance Inward | | | Selects text in the buffer that contains the current tag based on the current insertion cursor. Calling this function again will shrink the selection to include child tags. Only valid for XML-like syntaxes. |
| Emmet / Go to Matching Pair | | | Places the insertion at the beginning of the current tags matching pair (i.e., if the insertion cursor is within an ending tag, this action will move the cursor to the beginning of the start tag that matches this tag). Only valid for XML-like syntaxes. |
| Emmet / Toggle Comment | | | Toggles the comment status of the current HTML/XML node or CSS ruleset. |
| Emmet / Split/Join Tag | | | If the current tag is both a start and and end tag (i.e., \<p /\>), splits the tag into both a starting and ending tag (i.e., \<p\>\</p\>). Likewise, if the cursor is with a split HTML/XML node, the tags will be combined to a combination tag (and all child content will be deleted). Only valid for XML-like syntaxes. |
| Emmet / Remove Tag | | | Removes the tag (and its matching tag) from the buffer and adjusts the indentation of child nodes. Only valid for XML-like syntaxes. |
| Emmet / Merge Lines | | | Joins all lines that are a part of the current HTML/XML node into a single line. Only valid for XML-like syntaxes. |
| Emmet / Update Image Size | | | If the insertion cursor is within an image tag, this action will insert and/or update the width and height attributes to match the image specified in the src attribute. If the insertion cursor is within a CSS url() function, this action will insert and/or update the width and height properties to match the image specified in the url() function parameter. |
| Emmet / Encode/Decode Image to Data:URL | | | If the insertion cursor is within an \<img\> src attribute value, it will convert the image file into an embedded resource using base64. Likewise, if the src attribute value contains embedded resource information, it will decode the base64 information and save it as a local file that you can specify with a save dialog box. This also works for images defined within a CSS url() function. |
| Emmet / Reflect CSS Value | | | When a property value is updated, any other properties which are the same as the modified property are updated to the same value.
| Emmet / Next Edit Point | | | Moves the insertion cursor to the next edit point after the current insertion cursor as defined by the Emmet action description. |
| Emmet / Previous Edit Point | | | Moves the insertion cursor to the next edit point before the current insertion cursor as defined by the Emmet action description. |
| Emmet / Select Next Item | | | Selects the next item after the current insertion cursor as defined by the Emmet action description. |
| Emmet / Select Previous Item | | | Selects the next item before the current insertion cursor as defined by the Emmet action description. |
| Emmet / Evaluate Math Expression | | | When the cursor is placed at the end of a mathematical equation that does not contain any spaces within itself, the equation will be evaluated and the result will replace expression in the editing buffer. Any valid Tcl expression syntax can be used. |
| Emmet / Increment by 10 | Ctrl-Shift-Up | Ctrl-Shift-Up | If the insertion cursor is placed within a number, this action will increase the number by 10. |
| Emmet / Increment by 1 | Ctrl-Up | Ctrl-Up | If the insertion cursor is placed within a number, this action will increase the number by 1. |
| Emmet / Increment by 0.1 | Shift-Up | Shift-Up | If the insertion cursor is placed within a number, this action will increase the number by 0.1 |
| Emmet / Decrement by 10 | Ctrl-Shift-Up | Ctrl-Shift-Up | If the insertion cursor is placed within a number, this action will decrease the number by 10. |
| Emmet / Decrement by 1 | Ctrl-Up | Ctrl-Up | If the insertion cursor is placed within a number, this action will decrease the number by 1. |
| Emmet / Decrement by 0.1 | Shift-Up | Shift-Up | If the insertion cursor is placed within a number, this action will decrease the number by 0.1 |
| Emmet / Edit Custom Abbreviations | | | Displays the custom Emmet abbreviation file in a new editing buffer allowing the user to change, remove or add custom Emmet syntax to their liking. Saving the editing buffer will cause the file changes to go into effect immediately. |
| Emmet / View Emmet Reference Guide | | | Displays the Emmet reference documentation in your preferred web browser. |
| Preferences / Edit User - Global | Cmd-, | Ctrl-, | Displays the user’s global (cross-language) preferences in an editor tab.  Saving changes made to this tab will immediately update the environment without restarting. |
| Preferences / Edit User - Language | | | Displays the user’s current language preferences in an editor tab.  Saving changes made to this tab will immediately update the environment without restarting. |
| Preferences / Delete User - Language | | | Deletes the preferences file (and related preferences) associated with the current language. The preferences will come from the user global preferences after this action takes place. |
| Preferences / Edit Session - Global | Cmd-; | Ctrl-; | Displays the current session’s global (cross-language) preferences in an editor tab.  This option will only be available if a named session is currently opened (see Session menu for details).  Saving changes made to this tab will immediately update the environment without restarting. |
| Preferences / Edit Session - Language | | | Displays the current session's current language preferences in an editor tab.  This option will only be available if a named session is currently opened.  Saving changes made to this tab will immediately update the environment without restarting. |
| Preferences / Delete Session - Language | | | Deletes the preferences file (and related preferences) associated with the current language of the current session. The preferences will come from the session global preferences after this action takes place. |